package jadean.dean.java;

import jadean.dean.java.constants.JavaProjectConstants;
import jadean.dean.java.resourceparser.jarparser.DefaultJarEntryFilter;
import jadean.dean.java.resourceparser.jarparser.DefaultJarEntryFormatter;
import jadean.dean.java.resourceparser.jarparser.JarEntryFilter;
import jadean.dean.java.resourceparser.jarparser.JarResourceUtilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;


public class JavaPackage {
	private String _jarFilePath;

	private String _jarFileName;
	
	public JavaPackage(String jarFilePath) {
		final String fileName = new File(jarFilePath).getName();
		final int extensionPosition = fileName.lastIndexOf('.');
		
		this.setPath(jarFilePath);
		this.setName(fileName.substring(0, extensionPosition)); 
	}
	
	public InputStream getInputStreamForClass(String className) throws IOException {
		return JarResourceUtilities.getInputStreamForEntry(this._jarFilePath, className);
	}
	
	public List<String> getResourcesInPackage(String javaPackageName) throws IOException {
		final String jarPackageName = javaPackageName.replace(".*", "").replace('.', JavaProjectConstants.JAR_FILE_ENTRIES_SEPARATOR);
		List<String> resources = JarResourceUtilities.listFiles(this._jarFilePath, new JarEntryFilter() {
			public boolean accept(JarEntry je) {
				DefaultJarEntryFilter djef = new DefaultJarEntryFilter();
				return djef.accept(je) && je.getName().startsWith(jarPackageName);
			}
		}, new DefaultJarEntryFormatter());
		return resources;
	}
	
	public List<String> getAllResources() throws IOException {
		System.out.println(this._jarFilePath);
		List<String> resources = JarResourceUtilities.listFiles(this._jarFilePath, new JarEntryFilter() {
			public boolean accept(JarEntry je) {
				DefaultJarEntryFilter djef = new DefaultJarEntryFilter();
				return djef.accept(je);
			}
		}, new DefaultJarEntryFormatter());		
		return resources;
	}
	
	public boolean hasClassPathPackages() {
		return JarResourceUtilities.hasClassPathPackages(this.getPath());
	}
	
	public List<JavaPackage> getClassPathPackages() {
		List<String> classPathPackagesFiles = JarResourceUtilities.getClassPathPackages(this.getPath());
		ArrayList<JavaPackage> classPathPackages = new ArrayList<JavaPackage>();
		for (String classPathPackage: classPathPackagesFiles) {
			classPathPackages.add(new JavaPackage(classPathPackage));
		}
		return classPathPackages;
	}
	
	public void removeResources(Set<JavaResource> resources) {
		ArrayList<String> entriesToDelete = new ArrayList<String>();
		for (JavaResource resource: resources) {
			entriesToDelete.add(resource.getName());
		}
		try {
			JarResourceUtilities.removeEntries(this.getPath(), entriesToDelete);
			JarResourceUtilities.deleteEmptyFolders(this.getPath());
		}
		catch (IOException e) {
		}
	}
	
	public String getPath() {
		return this._jarFilePath;
	}
	
	public String getName() {
		return this._jarFileName;
	}
	
	public void setPath(String path) {
		this._jarFilePath = path;
	}

	public void setName(String name) {
		this._jarFileName = name;
	}
	
	public boolean equals(Object o) {
		if (o instanceof JavaPackage) {
			JavaPackage p = (JavaPackage) o;
			return p.getPath().equals(this._jarFilePath);
		}
		return false;
	}
	
	public int hashCode() {
		return this._jarFilePath.hashCode();
	}
	
	public String toString() {
		return "JavaPackage [" + this._jarFileName + ": " + this._jarFilePath + "]";
	}
}
